<?php
session_start();
error_reporting(0);

// Check if logged in
if (!isset($_SESSION['agent_id'])) {
    header("Location: index.php");
    exit();
}

include_once('../include/db_config.php');
include_once('../lib/Agent.class.php');

$agent = new Agent();
$agentId = $_SESSION['agent_id'];
$agentData = $agent->getAgentById($agentId);

// Get all transactions
$transactions = $agent->getTransactions($agentId, 100);

include_once('include_head.php');
include_once('include_nav.php');
require_once(__DIR__ . '/include_digiflazz_print.php');
?>

<style>
.badge {
    padding: 4px 12px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
}

.badge-topup {
    background: #d1fae5;
    color: #065f46;
}

.badge-generate {
    background: #fee2e2;
    color: #991b1b;
}

.badge-status {
    display: inline-block;
    padding: 3px 10px;
    border-radius: 999px;
    font-size: 11px;
    font-weight: 700;
    letter-spacing: .4px;
    text-transform: uppercase;
}

.status-success {
    background: #dcfce7;
    color: #166534;
}

.status-pending {
    background: #fef3c7;
    color: #92400e;
}

.status-failed {
    background: #fee2e2;
    color: #b91c1c;
}

.status-note {
    margin-top: 4px;
    font-size: 11px;
    color: #475569;
}

.serial-chip {
    display: inline-block;
    margin-top: 6px;
    padding: 4px 10px;
    border-radius: 6px;
    background: rgba(15,23,42,0.08);
    font-family: 'Courier New', monospace;
    font-size: 12px;
    font-weight: 600;
    letter-spacing: 0.4px;
}

.dark .serial-chip {
    background: rgba(255,255,255,0.08);
    color: #f9fafb;
}

.desktop-only {
    display: block;
}

.mobile-only {
    display: none;
}

.transaction-card {
    background: #fff;
    border-radius: 14px;
    padding: 16px;
    margin-bottom: 16px;
    box-shadow: 0 8px 24px rgba(15,23,42,0.08);
    border: 1px solid rgba(15,23,42,0.06);
}

.transaction-card .card-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    gap: 12px;
    margin-bottom: 12px;
}

.transaction-card .card-header .date {
    font-weight: 700;
    font-size: 13px;
    color: #0f172a;
}

.transaction-card .card-header .type-badge {
    padding: 4px 10px;
    border-radius: 999px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.4px;
    color: #fff;
    background: #475569;
}

.transaction-card .badge-topup {
    background: #10b981;
}

.transaction-card .badge-generate,
.transaction-card .badge-digiflazz {
    background: #2563eb;
}

.transaction-card .card-row {
    display: flex;
    flex-direction: column;
    gap: 4px;
    margin-bottom: 12px;
}

.transaction-card .label {
    font-size: 11px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.4px;
    color: #475569;
}

.transaction-card .value {
    font-size: 13px;
    font-weight: 600;
    color: #0f172a;
    word-break: break-word;
}

.transaction-card .value-muted {
    color: #94a3b8;
    font-weight: 500;
}

.transaction-card .value-amount {
    font-size: 16px;
    font-weight: 700;
}

.transaction-card .value-amount.positive {
    color: #10b981;
}

.transaction-card .value-amount.negative {
    color: #ef4444;
}

.transaction-card .status-badge {
    display: inline-block;
    padding: 4px 12px;
    border-radius: 999px;
    font-size: 11px;
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.4px;
}

.transaction-card .status-note {
    font-size: 12px;
    color: #475569;
    margin-top: 6px;
}

.transaction-card .print-btn {
    margin-top: 16px;
    width: 100%;
    justify-content: center;
}

.dark .transaction-card {
    background: #111827;
    border-color: #1f2937;
    box-shadow: 0 12px 28px rgba(15,23,42,0.4);
}

.dark .transaction-card .label {
    color: #cbd5f5;
}

.dark .transaction-card .value {
    color: #f1f5f9;
}

.dark .transaction-card .value-muted {
    color: #94a3b8;
}

@media (max-width: 768px) {
    .desktop-only {
        display: none !important;
    }

    .mobile-only {
        display: block;
    }

    .transaction-card {
        display: block;
        width: 100%;
    }

    .table-responsive {
        overflow-x: hidden !important;
        width: 100% !important;
    }

    .transactions-table {
        display: none !important;
    }

    .transactions-table thead,
    .transactions-table tbody,
    .transactions-table tr,
    .transactions-table td {
        display: none !important;
    }
}

/* Mobile responsive table */
@media (max-width: 768px) {
    .content-wrapper {
        padding-left: 10px !important;
        padding-right: 10px !important;
        overflow-x: visible !important;
    }
    
    .row {
        margin-left: 0 !important;
        margin-right: 0 !important;
    }
    
    .col-12 {
        padding-left: 0 !important;
        padding-right: 0 !important;
    }
    
    .card {
        margin-bottom: 10px !important;
        border-radius: 4px !important;
    }
    
    .table-responsive {
        overflow-x: auto !important;
        overflow-y: visible !important;
        -webkit-overflow-scrolling: touch !important;
        width: 100% !important;
        max-width: 100% !important;
        display: block !important;
        margin: 0 !important;
        -ms-overflow-style: -ms-autohiding-scrollbar !important;
        position: relative !important;
    }
    
    .table-responsive::-webkit-scrollbar {
        height: 8px !important;
        -webkit-appearance: none !important;
    }
    
    .table-responsive::-webkit-scrollbar-track {
        background: #f1f1f1 !important;
        border-radius: 4px !important;
    }
    
    .table-responsive::-webkit-scrollbar-thumb {
        background: #888 !important;
        border-radius: 4px !important;
    }
    
    .table-responsive::-webkit-scrollbar-thumb:hover {
        background: #555 !important;
    }
    
    .table-responsive table {
        width: 100% !important;
        min-width: 600px !important;
        font-size: 12px !important;
        margin-bottom: 0 !important;
        display: table !important;
        table-layout: auto !important;
    }
    
    .table-responsive th,
    .table-responsive td {
        padding: 8px 6px !important;
        white-space: nowrap !important;
        font-size: 11px !important;
    }
    
    .card-body {
        padding: 10px !important;
        overflow-x: visible !important;
        overflow-y: visible !important;
        max-width: 100% !important;
    }
    
    .card {
        overflow: visible !important;
        max-width: 100% !important;
    }
    
    .card-header {
        padding: 10px !important;
        font-size: 14px !important;
    }
    
    .card-header h3 {
        font-size: 16px !important;
        margin-bottom: 5px !important;
    }
    
    /* Make table more compact on mobile */
    .table-bordered {
        border-collapse: collapse !important;
    }
    
    .badge {
        padding: 3px 8px !important;
        font-size: 10px !important;
    }
}

</style>

<div class="row">
<div class="col-12">
<div class="card">
    <div class="card-header">
        <h3><i class="fa fa-history"></i> Transaction History</h3>
        <div style="font-size: 14px;">Current Balance: <strong>Rp <?= number_format($agentData['balance'], 0, ',', '.'); ?></strong></div>
    </div>
    <div class="card-body" style="padding: 15px;">
        <?php if (!empty($transactions)): ?>
        <div class="desktop-only">
        <div class="table-responsive" style="overflow-x: visible !important; -webkit-overflow-scrolling: touch !important; width: 100% !important; display: block !important; -ms-overflow-style: -ms-autohiding-scrollbar !important;">
        <table class="table table-bordered table-hover transactions-table" style="width: 100% !important; margin-bottom: 0 !important; display: table !important;">
            <thead>
                <tr>
                    <th style="padding: 8px 6px; font-size: 12px; white-space: nowrap;">Date & Time</th>
                    <th style="padding: 8px 6px; font-size: 12px; white-space: nowrap;">Type</th>
                    <th style="padding: 8px 6px; font-size: 12px; white-space: nowrap;">Amount</th>
                    <th style="padding: 8px 6px; font-size: 12px; white-space: nowrap;">Status</th>
                    <th style="padding: 8px 6px; font-size: 12px; white-space: nowrap;">SN</th>
                    <th style="padding: 8px 6px; font-size: 12px; white-space: nowrap;">Balance Before</th>
                    <th style="padding: 8px 6px; font-size: 12px; white-space: nowrap;">Balance After</th>
                    <th style="padding: 8px 6px; font-size: 12px; white-space: nowrap;">Description</th>
                    <th style="padding: 8px 6px; font-size: 12px; white-space: nowrap;">Print</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($transactions as $trx): ?>
                <tr>
                    <td data-label="Date" style="padding: 8px 6px; font-size: 11px; white-space: nowrap;"><?= date('d M Y H:i', strtotime($trx['created_at'])); ?></td>
                    <td data-label="Type" style="padding: 8px 6px; font-size: 11px;">
                        <span class="badge badge-<?= $trx['transaction_type']; ?>">
                            <?= ucfirst($trx['transaction_type']); ?>
                        </span>
                    </td>
                    <td data-label="Amount" style="padding: 8px 6px; font-size: 11px; font-weight: bold; color: <?= $trx['transaction_type'] == 'topup' ? '#10b981' : '#ef4444'; ?>; white-space: nowrap;">
                        <?= $trx['transaction_type'] == 'topup' ? '+' : '-'; ?>Rp <?= number_format($trx['amount'], 0, ',', '.'); ?>
                    </td>
                    <td data-label="Status" style="padding: 8px 6px; font-size: 11px; white-space: nowrap;">
                        <?php if ($trx['transaction_type'] === 'digiflazz'): ?>
                            <?php
                                $statusRaw = strtolower($trx['digiflazz_status'] ?? '');
                                $statusClass = 'status-pending';
                                $statusLabel = 'PENDING';

                                if (!$statusRaw || in_array($statusRaw, ['success', 'sukses', 'berhasil', 'ok'])) {
                                    $statusClass = 'status-success';
                                    $statusLabel = 'BERHASIL';
                                } elseif (in_array($statusRaw, ['pending', 'process', 'processing', 'menunggu'])) {
                                    $statusClass = 'status-pending';
                                    $statusLabel = 'PENDING';
                                } else {
                                    $statusClass = 'status-failed';
                                    $statusLabel = strtoupper($statusRaw);
                                }
                            ?>
                            <span class="badge-status <?= $statusClass; ?>"><?= htmlspecialchars($statusLabel); ?></span>
                            <?php if (!empty($trx['digiflazz_message'])): ?>
                                <div class="status-note"><?= htmlspecialchars($trx['digiflazz_message']); ?></div>
                            <?php endif; ?>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                    <td data-label="SN" style="padding: 8px 6px; font-size: 11px; white-space: nowrap;">
                        <?php if ($trx['transaction_type'] === 'digiflazz' && !empty($trx['digiflazz_serial'])): ?>
                            <span class="serial-chip"><?= htmlspecialchars($trx['digiflazz_serial']); ?></span>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                    <td data-label="Saldo Sebelum" style="padding: 8px 6px; font-size: 11px; white-space: nowrap;">Rp <?= number_format($trx['balance_before'], 0, ',', '.'); ?></td>
                    <td data-label="Saldo Sesudah" style="padding: 8px 6px; font-size: 11px; white-space: nowrap;">Rp <?= number_format($trx['balance_after'], 0, ',', '.'); ?></td>
                    <td data-label="Keterangan" style="padding: 8px 6px; font-size: 11px; white-space: normal;">&nbsp;<?= htmlspecialchars($trx['description'] ?: ($trx['profile_name'] . ' - ' . $trx['voucher_username'])); ?></td>
                    <td data-label="Print" style="padding: 8px 6px; font-size: 11px; white-space: nowrap; text-align: center;">
                        <?php if ($trx['transaction_type'] === 'digiflazz'): ?>
                            <?php
                                $sellPrice = isset($trx['digiflazz_sell_price']) && $trx['digiflazz_sell_price'] !== null ? (int)$trx['digiflazz_sell_price'] : abs((int)$trx['amount']);
                                $basePrice = isset($trx['digiflazz_base_price']) && $trx['digiflazz_base_price'] !== null ? (int)$trx['digiflazz_base_price'] : $sellPrice;
                            ?>
                            <button
                                class="print-btn"
                                data-digiflazz-print
                                data-ref="<?= htmlspecialchars($trx['voucher_username']); ?>"
                                data-product="<?= htmlspecialchars($trx['profile_name'] ?: ''); ?>"
                                data-description="<?= htmlspecialchars($trx['description'] ?: ''); ?>"
                                data-status="<?= htmlspecialchars($statusLabel); ?>"
                                data-status-class="<?= htmlspecialchars($statusClass); ?>"
                                data-message="<?= htmlspecialchars($trx['digiflazz_message'] ?? ''); ?>"
                                data-customer-no="<?= htmlspecialchars($trx['digiflazz_customer_no'] ?? ''); ?>"
                                data-customer-name="<?= htmlspecialchars($trx['digiflazz_customer_name'] ?? ''); ?>"
                                data-serial="<?= htmlspecialchars($trx['digiflazz_serial'] ?? ''); ?>"
                                data-sell-price="<?= $sellPrice; ?>"
                                data-base-price="<?= $basePrice; ?>"
                                data-created-at="<?= htmlspecialchars($trx['created_at']); ?>"
                            >
                                <i class="fa fa-print"></i> Cetak
                            </button>
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        </div>
        </div>

        <div class="mobile-only">
            <?php foreach ($transactions as $trx): ?>
                <?php
                    $statusRaw = strtolower($trx['digiflazz_status'] ?? '');
                    $statusClass = 'status-pending';
                    $statusLabel = 'PENDING';

                    if (!$statusRaw || in_array($statusRaw, ['success', 'sukses', 'berhasil', 'ok'])) {
                        $statusClass = 'status-success';
                        $statusLabel = 'BERHASIL';
                    } elseif (in_array($statusRaw, ['pending', 'process', 'processing', 'menunggu'])) {
                        $statusClass = 'status-pending';
                        $statusLabel = 'PENDING';
                    } elseif ($statusRaw) {
                        $statusClass = 'status-failed';
                        $statusLabel = strtoupper($statusRaw);
                    }

                    $isDebit = ($trx['transaction_type'] !== 'topup');
                    $amountPrefix = $isDebit ? '-' : '+';
                    $amountColorClass = $isDebit ? 'negative' : 'positive';
                    $statusNote = $trx['digiflazz_message'] ?? '';
                    $sellPrice = isset($trx['digiflazz_sell_price']) && $trx['digiflazz_sell_price'] !== null ? (int)$trx['digiflazz_sell_price'] : abs((int)$trx['amount']);
                    $basePrice = isset($trx['digiflazz_base_price']) && $trx['digiflazz_base_price'] !== null ? (int)$trx['digiflazz_base_price'] : $sellPrice;
                ?>
                <div class="transaction-card">
                    <div class="card-header">
                        <div class="date"><?= date('d M Y H:i', strtotime($trx['created_at'])); ?></div>
                        <div class="type-badge badge-<?= htmlspecialchars($trx['transaction_type']); ?>">
                            <?= ucfirst($trx['transaction_type']); ?>
                        </div>
                    </div>

                    <div class="card-row">
                        <div class="label">Amount</div>
                        <div class="value value-amount <?= $amountColorClass; ?>"><?= $amountPrefix; ?>Rp <?= number_format($trx['amount'], 0, ',', '.'); ?></div>
                    </div>

                    <?php if ($trx['transaction_type'] === 'digiflazz'): ?>
                        <div class="card-row">
                            <div class="label">Status</div>
                            <div>
                                <span class="status-badge <?= $statusClass; ?>"><?= htmlspecialchars($statusLabel); ?></span>
                                <?php if (!empty($statusNote)): ?>
                                    <div class="status-note"><?= htmlspecialchars($statusNote); ?></div>
                                <?php endif; ?>
                            </div>
                        </div>
                        <?php if (!empty($trx['digiflazz_customer_no'])): ?>
                            <div class="card-row">
                                <div class="label">Nomor Tujuan</div>
                                <div class="value"><?= htmlspecialchars($trx['digiflazz_customer_no']); ?></div>
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($trx['digiflazz_serial'])): ?>
                            <div class="card-row">
                                <div class="label">Serial Number</div>
                                <div class="value serial-chip"><?= htmlspecialchars($trx['digiflazz_serial']); ?></div>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>

                    <div class="card-row">
                        <div class="label">Saldo Sebelum</div>
                        <div class="value value-muted">Rp <?= number_format($trx['balance_before'], 0, ',', '.'); ?></div>
                    </div>

                    <div class="card-row">
                        <div class="label">Saldo Sesudah</div>
                        <div class="value value-muted">Rp <?= number_format($trx['balance_after'], 0, ',', '.'); ?></div>
                    </div>

                    <div class="card-row">
                        <div class="label">Keterangan</div>
                        <div class="value"><?= htmlspecialchars($trx['description'] ?: ($trx['profile_name'] . ' - ' . $trx['voucher_username'])); ?></div>
                    </div>

                    <?php if ($trx['transaction_type'] === 'digiflazz'): ?>
                        <div class="card-row">
                            <div class="label">Ref ID</div>
                            <div class="value"><?= htmlspecialchars($trx['voucher_username']); ?></div>
                        </div>
                        <div class="card-row">
                            <div class="label">Modal</div>
                            <div class="value value-muted">Rp <?= number_format($basePrice, 0, ',', '.'); ?></div>
                        </div>
                        <div class="card-row">
                            <div class="label">Harga Jual</div>
                            <div class="value value-muted">Rp <?= number_format($sellPrice, 0, ',', '.'); ?></div>
                        </div>
                        <button
                            class="print-btn"
                            data-digiflazz-print
                            data-ref="<?= htmlspecialchars($trx['voucher_username']); ?>"
                            data-product="<?= htmlspecialchars($trx['profile_name'] ?: ''); ?>"
                            data-description="<?= htmlspecialchars($trx['description'] ?: ($trx['profile_name'] . ' - ' . $trx['voucher_username'])); ?>"
                            data-status="<?= htmlspecialchars($statusLabel); ?>"
                            data-status-class="<?= htmlspecialchars($statusClass); ?>"
                            data-message="<?= htmlspecialchars($statusNote); ?>"
                            data-customer-no="<?= htmlspecialchars($trx['digiflazz_customer_no'] ?? ''); ?>"
                            data-customer-name="<?= htmlspecialchars($trx['digiflazz_customer_name'] ?? ''); ?>"
                            data-serial="<?= htmlspecialchars($trx['digiflazz_serial'] ?? ''); ?>"
                            data-sell-price="<?= $sellPrice; ?>"
                            data-base-price="<?= $basePrice; ?>"
                            data-created-at="<?= htmlspecialchars($trx['created_at']); ?>"
                        >
                            <i class="fa fa-print"></i> Cetak
                        </button>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>

        <?php else: ?>
        <div class="alert alert-info">
            <i class="fa fa-info-circle"></i> No transactions found.
        </div>
        <?php endif; ?>
    </div>
</div>
</div>
</div>

<?php include_once('include_foot.php'); ?>
